/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.events;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.field.FieldHelper;
import dev.compactmods.crafting.field.MissingFieldsException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compactcrafting")
public class BlockEventHandler {
    @SubscribeEvent
    static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        LivingEntity entity = event.getEntityLiving();
        BlockHitResult hitVec = event.getHitVec();
        Level w = event.getWorld();
        if (w.f_46443_) {
            BlockPos placedAt = hitVec.m_82425_().m_142300_(hitVec.m_82434_());
            try {
                boolean allowPlace = FieldHelper.checkBlockPlacement(w, placedAt);
                if (!allowPlace) {
                    event.setCanceled(true);
                }
            }
            catch (MissingFieldsException e) {
                CompactCrafting.LOGGER.error("Missing the active miniaturization fields capability in the level. Report this!");
            }
        }
    }

    @SubscribeEvent
    static void onBlockPlaced(BlockEvent.EntityPlaceEvent blockPlaced) {
        BlockEventHandler.blockHandler((BlockEvent)blockPlaced);
    }

    @SubscribeEvent
    static void onBlockDestroyed(BlockEvent.BreakEvent blockDestroyed) {
        BlockEventHandler.blockHandler((BlockEvent)blockDestroyed);
    }

    private static void blockHandler(BlockEvent event) {
        LevelAccessor world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world instanceof Level) {
            try {
                boolean allowPlace = FieldHelper.checkBlockPlacement((Level)world, pos);
                if (!allowPlace) {
                    event.setCanceled(true);
                }
            }
            catch (MissingFieldsException e) {
                CompactCrafting.LOGGER.error("Missing the active miniaturization fields capability in the level. Report this!");
            }
        }
    }
}

